/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.i18n;

import com.lf.commons.config.Configuration;
import com.lf.commons.lang.JavaUtils;
import com.lf.commons.resource.ResourceLocator;
import java.util.Hashtable;

public class IANACharsets {
    protected Hashtable<String, String> cacheMIMEByName;
    protected Hashtable<String, String> cacheNameByMIME;
    protected Hashtable<String, String[]> cacheAliasesByName;
    protected Hashtable<String, String> cacheNameByAlias;
    protected Hashtable<String, String> cacheNormalized;
    protected String resourceFile = "character-sets.conf";

    public IANACharsets() {
        this.installInitialCaches();
    }

    protected void installInitialCaches() {
        Configuration config;
        this.cacheAliasesByName = new Hashtable(0);
        this.cacheMIMEByName = new Hashtable(0);
        this.cacheNormalized = new Hashtable(0);
        try {
            config = new Configuration();
            config.read(ResourceLocator.class.getResourceAsStream(this.resourceFile));
        }
        catch (Exception e) {
            throw new RuntimeException("Resource file could not be imported!");
        }
        int index = 1;
        boolean finished = false;
        while (!finished) {
            String mime;
            String alias;
            String normalized;
            String name;
            try {
                name = (String)config.getObject("CS_" + index + "_NAME", String.class.getName());
                normalized = name.toUpperCase();
            }
            catch (Exception e) {
                finished = true;
                continue;
            }
            String[] aliases = null;
            int aliasindex = 1;
            try {
                alias = (String)config.getObject("CS_" + index + "_AKA_" + aliasindex, String.class.getName());
                aliases = new String[]{alias};
                ++aliasindex;
            }
            catch (Exception e) {
                aliasindex = -1;
            }
            while (aliasindex != -1) {
                try {
                    alias = (String)config.getObject("CS_" + index + "_AKA_" + aliasindex, String.class.getName());
                    aliases = (String[])JavaUtils.addToArray(aliases, alias);
                    ++aliasindex;
                }
                catch (Exception e) {
                    aliasindex = -1;
                }
            }
            if (aliases != null) {
                this.cacheAliasesByName.put(normalized, aliases);
            }
            try {
                mime = (String)config.getObject("CS_" + index + "_MIME", String.class.getName());
            }
            catch (Exception e) {
                mime = name;
            }
            this.cacheMIMEByName.put(normalized, mime);
            this.cacheNormalized.put(normalized, name);
            ++index;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cacheMIMEByName != null) {
            this.cacheMIMEByName.clear();
        }
        if (this.cacheNameByMIME != null) {
            this.cacheNameByMIME.clear();
        }
        if (this.cacheAliasesByName != null) {
            this.cacheAliasesByName.clear();
        }
        if (this.cacheNameByAlias != null) {
            this.cacheNameByAlias.clear();
        }
        if (this.cacheNormalized != null) {
            this.cacheNormalized.clear();
        }
    }
}

