/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.i18n;

import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.I18NFactory;
import com.lf.commons.i18n.LanguageCodes;
import com.lf.commons.i18n.Locale;
import com.lf.commons.i18n.Localize;
import com.lf.commons.i18n.spi.Localization;
import com.lf.vfslib.net.VFSFileSystemManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ServiceLoader;
import java.util.Vector;
import org.apache.commons.vfs2.FileObject;

public class I18NUtils {
    public static Vector<Locale> getLocalesVFS(FileObject base) {
        if (base == null) {
            throw new NullPointerException();
        }
        Vector<Locale> result = new Vector<Locale>(1);
        try {
            FileObject[] childs = base.getChildren();
            for (int i = 0; i < childs.length; ++i) {
                String next = childs[i].getName().getBaseName();
                try {
                    Locale locale = Locale.parseLocale(next);
                    if (locale == null) continue;
                    result.addElement(locale);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static Vector<Locale> getLocaleSynonyms(Locale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        Vector<Locale> result = new Vector<Locale>(1);
        try {
            I18NFactory factory = I18NFactory.getSharedInstance();
            LanguageCodes lcodes = (LanguageCodes)factory.request(I18NFactory.ID_LANGUAGES);
            String langcode = locale.getLanguage();
            if (langcode.length() == 2) {
                String[] codes639_2 = lcodes.get639_2By639_1(langcode);
                if (codes639_2 != null) {
                    for (int i = 0; i < codes639_2.length; ++i) {
                        String synlocale = locale.toString().replaceFirst("(^" + langcode + ')', codes639_2[i]);
                        if (locale == null) continue;
                        result.addElement(Locale.parseLocale(synlocale));
                    }
                }
            } else if (langcode.length() == 3) {
                String[] others;
                String codes639_1 = lcodes.get639_1By639_2(langcode);
                if (codes639_1 != null) {
                    String synlocale = locale.toString().replaceFirst("(^" + langcode + ')', codes639_1);
                    if (locale != null) {
                        result.addElement(Locale.parseLocale(synlocale));
                    }
                }
                if ((others = lcodes.get639_2Synonyms(langcode)) != null) {
                    for (int i = 0; i < others.length; ++i) {
                        String synlocale = locale.toString().replaceFirst("(^" + langcode + ')', others[i]);
                        if (locale == null) continue;
                        result.addElement(Locale.parseLocale(synlocale));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static FileObject getLocalizationVFS(String base, Locale locale, Object loader) {
        if (base == null || locale == null || loader == null) {
            throw new NullPointerException();
        }
        String path = '/' + base.replaceAll("([\\.])", "/") + '/' + locale.toString() + '/';
        try {
            VFSFileSystemManager vfsmananager = CommonsSettings.getManagerClasspath();
            String dummy = "Localization_" + locale.toString() + ".class";
            String temp = loader.getClass().getResource(path + dummy).toString();
            temp = temp.substring(0, temp.length() - dummy.length() - 1);
            return vfsmananager.resolveFile(temp);
        }
        catch (Exception e) {
            try {
                ServiceLoader<Localization> service = ServiceLoader.load(Localization.class, loader.getClass().getClassLoader());
                for (Localization provider : service) {
                    if (!provider.getClass().getName().startsWith(base) || !locale.equals(provider.getLocale())) continue;
                    VFSFileSystemManager vfsmananager = CommonsSettings.getManagerClasspath();
                    String dummy = "Localization_" + locale.toString() + ".class";
                    String temp = provider.getClass().getResource(path + dummy).toString();
                    temp = temp.substring(0, temp.length() - dummy.length() - 1);
                    return vfsmananager.resolveFile(temp);
                }
            }
            catch (Exception e2) {
                // empty catch block
            }
            return null;
        }
    }

    public static Vector<Locale> getSupportedLocales(String base, Object loader, boolean synonyms) {
        Vector<Locale> result;
        block14: {
            Locale locale;
            boolean debug;
            block13: {
                block12: {
                    if (base == null || loader == null) {
                        throw new NullPointerException();
                    }
                    result = new Vector<Locale>(0);
                    debug = false;
                    try {
                        String path = '/' + base.replaceAll("([\\.])", "/") + '/';
                        VFSFileSystemManager vfsmananager = CommonsSettings.getManagerClasspath();
                        FileObject vfspath = vfsmananager.resolveFile(loader.getClass().getResource(path).toString());
                        Vector<Locale> candidates = I18NUtils.getLocalesVFS(vfspath);
                        for (Locale next : candidates) {
                            if (result.contains(next)) continue;
                            result.addElement(next);
                        }
                    }
                    catch (Exception e) {
                        if (!debug) break block12;
                        e.printStackTrace();
                    }
                }
                try {
                    ServiceLoader<Localization> service = ServiceLoader.load(Localization.class, loader.getClass().getClassLoader());
                    for (Localization provider : service) {
                        if (!provider.getClass().getName().startsWith(base) || result.contains(locale = provider.getLocale())) continue;
                        result.addElement(locale);
                    }
                }
                catch (Exception e) {
                    if (!debug) break block13;
                    e.printStackTrace();
                }
            }
            if (synonyms) {
                try {
                    int size = result.size();
                    for (int i = 0; i < size; ++i) {
                        Vector<Locale> syns = I18NUtils.getLocaleSynonyms(result.elementAt(i));
                        int size2 = syns.size();
                        for (int s = 0; s < size2; ++s) {
                            locale = syns.elementAt(s);
                            if (result.contains(locale)) continue;
                            result.addElement(locale);
                        }
                    }
                }
                catch (Exception e) {
                    if (!debug) break block14;
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static String getLocalizationValue(Class clazz, String variable) {
        if (clazz == null) {
            throw new NullPointerException("Localization target must not be null");
        }
        try {
            Annotation[] annotations;
            Constructor constructor = clazz.getConstructor(new Class[0]);
            for (Annotation next : annotations = constructor.getAnnotations()) {
                Localize.Variable[] localizers;
                if (!(next instanceof Localize)) continue;
                for (Localize.Variable nextvar : localizers = ((Localize)next).value()) {
                    if (!nextvar.name().equals(variable)) continue;
                    return nextvar.value();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

