/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.i18n;

import com.lf.commons.i18n.CountryCodes;
import com.lf.commons.i18n.IANACharsets;
import com.lf.commons.i18n.LanguageCodes;
import com.lf.commons.lang.ManagedFactory;
import com.lf.commons.lang.ManagedObject;
import com.lf.commons.lang.strategy.TimeoutStrategy;
import java.util.Date;

public class I18NFactory
extends ManagedFactory {
    protected static I18NFactory sharedInstance;
    public static final String ID_LANGUAGES;
    public static final String ID_CHARSETS;
    public static final String ID_COUNTRIES;

    public I18NFactory() {
        String clazz = LanguageCodes.class.getName();
        ManagedObject object = new ManagedObject(null, ID_LANGUAGES, clazz, new TimeoutStrategy(10), null, 0, 0);
        this.cacheObjectByID.put(ID_LANGUAGES, object);
        clazz = IANACharsets.class.getName();
        object = new ManagedObject(null, ID_CHARSETS, clazz, new TimeoutStrategy(10), null, 0, 0);
        this.cacheObjectByID.put(ID_CHARSETS, object);
        clazz = CountryCodes.class.getName();
        object = new ManagedObject(null, ID_COUNTRIES, clazz, new TimeoutStrategy(10), null, 0, 0);
        this.cacheObjectByID.put(ID_COUNTRIES, object);
    }

    public static synchronized I18NFactory getSharedInstance() {
        if (sharedInstance == null) {
            sharedInstance = new I18NFactory();
        }
        return sharedInstance;
    }

    @Override
    public synchronized Object request(Object id) {
        ManagedObject managed = this.cacheObjectByID.get(id);
        if (managed == null) {
            return null;
        }
        if (managed.object != null) {
            managed.lastRequest = new Date();
            ++managed.requestCount;
            return managed.object;
        }
        if (id.equals(ID_LANGUAGES)) {
            managed.object = new LanguageCodes();
        } else if (id.equals(ID_CHARSETS)) {
            managed.object = new IANACharsets();
        } else if (id.equals(ID_COUNTRIES)) {
            managed.object = new CountryCodes();
        }
        if (managed.object != null) {
            managed.lastRequest = new Date();
            managed.requestCount = 1;
            return managed.object;
        }
        return null;
    }

    @Override
    public synchronized boolean canRelease(Object id) {
        return true;
    }

    @Override
    public synchronized void cleanup(Object id) {
    }

    static {
        ID_LANGUAGES = LanguageCodes.class.getName();
        ID_CHARSETS = IANACharsets.class.getName();
        ID_COUNTRIES = CountryCodes.class.getName();
    }
}

