/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.i18n;

import com.lf.commons.config.Configuration;
import com.lf.commons.core.CommonsSettings;
import com.lf.commons.i18n.Locale;
import java.util.Enumeration;
import java.util.Hashtable;

public class CountryCodes {
    protected Hashtable<String, String> cacheNameBy3166_1;
    protected Hashtable<String, String> cache3166_1ByName;
    protected Hashtable<Locale, Hashtable<String, String>> cacheTranslations;
    protected Locale locale;

    public CountryCodes() {
        this.installInitialCaches();
    }

    protected void installInitialCaches() {
        Configuration config;
        CommonsSettings settings = CommonsSettings.getSharedInstance();
        this.locale = settings.getLogLocale();
        this.cacheNameBy3166_1 = new Hashtable(0);
        try {
            config = new Configuration();
            config.read(CommonsSettings.class.getResourceAsStream("i18n/" + this.locale + "/countries.conf"));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Resource file could not be imported!");
        }
        int index = 1;
        boolean finished = false;
        while (!finished) {
            String iso3166_1;
            String name;
            try {
                name = (String)config.getObject("COUNTRY_" + index + "_NAME", String.class.getName());
                iso3166_1 = (String)config.getObject("COUNTRY_" + index + "_ISO3166-1", String.class.getName());
            }
            catch (Exception e) {
                finished = true;
                continue;
            }
            try {
                this.cacheNameBy3166_1.put(iso3166_1, name);
            }
            catch (Exception e) {
                throw new RuntimeException("Country data could not be stored into cache!");
            }
            ++index;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.cacheNameBy3166_1 != null) {
            this.cacheNameBy3166_1.clear();
        }
        if (this.cache3166_1ByName != null) {
            this.cache3166_1ByName.clear();
        }
        if (this.cacheTranslations != null) {
            Enumeration<Locale> enumeration = this.cacheTranslations.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable<String, String> hash = this.cacheTranslations.get(enumeration.nextElement());
                hash.clear();
            }
            this.cacheTranslations.clear();
        }
    }
}

