/*
 * Decompiled with CFR 0.152.
 */
package com.lf.commons.crypto;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public final class PassphraseExtractor {
    public static synchronized String extractHex(InputStream istream, int length) throws IOException {
        String passphrase;
        block6: {
            passphrase = "";
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            while (istream.available() > 0) {
                int len = istream.read(buffer);
                ostream.write(buffer, 0, len);
            }
            ostream.close();
            byte[] bytes = ostream.toByteArray();
            if (bytes.length == 0) {
                return passphrase;
            }
            if (length % 2 != 0) {
                length = 64;
            }
            Hashtable<Integer, Integer> dirty = new Hashtable<Integer, Integer>(1);
            int index = 0;
            do {
                if (!dirty.containsKey(index) && PassphraseExtractor.isPrime(bytes[index])) {
                    int value = bytes[index] & 0xFF ^ index & 0xFF;
                    String hex = Integer.toHexString(value);
                    if ((passphrase = passphrase + (hex.length() == 1 ? '0' + hex : hex)).length() != length) {
                        dirty.put(index, index);
                        if ((index += (int)(((double)value + 1.0) * ((double)bytes.length * 0.5) / 256.0)) < bytes.length) continue;
                        index -= bytes.length;
                        continue;
                    }
                    break block6;
                }
                dirty.put(index, index);
                if (++index < bytes.length) continue;
                index = 0;
            } while (dirty.size() != bytes.length);
            throw new IllegalArgumentException("Cannot generate passphrase from random file");
        }
        return passphrase;
    }

    public static boolean isPrime(byte value) {
        int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251};
        int intval = value & 0xFF;
        for (int i = 0; i < primes.length; ++i) {
            if (intval != primes[i]) continue;
            return true;
        }
        return false;
    }
}

