/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.util;

public final class Maybe<T> {
    private final boolean isJust;
    private final T value;
    private static final Maybe<Object> Nothing = new Maybe<Object>(false, null);

    private Maybe(boolean isJust, T value) {
        this.isJust = isJust;
        this.value = value;
    }

    public boolean isNothing() {
        return !this.isJust;
    }

    public boolean isJust() {
        return this.isJust;
    }

    public T getJust() {
        return this.value;
    }

    public T get(T def) {
        if (this.isJust) {
            return this.value;
        }
        return def;
    }

    public static <T> Maybe<T> Nothing() {
        return Nothing;
    }

    public static <T> Maybe<T> Just(T value) {
        return new Maybe<T>(true, value);
    }

    public boolean equals(Object other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.equals((Maybe)other);
    }

    public boolean equals(Maybe<?> other) {
        return this.isJust == other.isJust && Maybe.eq(this.value, other.value);
    }

    private static boolean eq(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    public String toString() {
        if (this.isJust) {
            return "Just(" + this.value + ")";
        }
        return "Nothing";
    }

    public int hashCode() {
        if (!this.isJust) {
            return 0;
        }
        if (this.value == null) {
            return 1;
        }
        return this.value.hashCode();
    }
}

