/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAccountInfo;
import com.dropbox.core.DbxDelta;
import com.dropbox.core.DbxDeltaC;
import com.dropbox.core.DbxEntry;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxPath;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.DbxRequestUtil;
import com.dropbox.core.DbxStreamWriter;
import com.dropbox.core.DbxThumbnailFormat;
import com.dropbox.core.DbxThumbnailSize;
import com.dropbox.core.DbxUrlWithExpiration;
import com.dropbox.core.DbxWriteMode;
import com.dropbox.core.NoThrowOutputStream;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.json.JsonArrayReader;
import com.dropbox.core.json.JsonDateReader;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.Collector;
import com.dropbox.core.util.CountingOutputStream;
import com.dropbox.core.util.DumpWriter;
import com.dropbox.core.util.Dumpable;
import com.dropbox.core.util.IOUtil;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.util.Maybe;
import com.dropbox.core.util.StringUtil;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public final class DbxClient {
    private final DbxRequestConfig requestConfig;
    private final String accessToken;
    private final DbxHost host;
    private static final long ChunkedUploadThreshold = 0x800000L;
    private static final int ChunkedUploadChunkSize = 0x400000;

    public DbxClient(DbxRequestConfig requestConfig, String accessToken) {
        this(requestConfig, accessToken, DbxHost.Default);
    }

    public DbxClient(DbxRequestConfig requestConfig, String accessToken, DbxHost host) {
        if (requestConfig == null) {
            throw new IllegalArgumentException("'requestConfig' is null");
        }
        if (accessToken == null) {
            throw new IllegalArgumentException("'accessToken' is null");
        }
        if (host == null) {
            throw new IllegalArgumentException("'host' is null");
        }
        this.requestConfig = requestConfig;
        this.accessToken = accessToken;
        this.host = host;
    }

    public DbxRequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public DbxEntry getMetadata(String path) throws DbxException {
        DbxPath.checkArg("path", path);
        String host = this.host.api;
        String apiPath = "1/metadata/auto" + path;
        String[] params = new String[]{"list", "false"};
        return this.doGet(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 404) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.Reader, response.body);
            }
        });
    }

    public DbxEntry.WithChildren getMetadataWithChildren(String path) throws DbxException {
        return this.getMetadataWithChildrenBase(path, DbxEntry.WithChildren.Reader);
    }

    public <C> DbxEntry.WithChildrenC<C> getMetadataWithChildrenC(String path, Collector<DbxEntry, ? extends C> collector) throws DbxException {
        return (DbxEntry.WithChildrenC)this.getMetadataWithChildrenBase(path, new DbxEntry.WithChildrenC.Reader<C>(collector));
    }

    private <T> T getMetadataWithChildrenBase(String path, final JsonReader<? extends T> reader) throws DbxException {
        DbxPath.checkArg("path", path);
        String host = this.host.api;
        String apiPath = "1/metadata/auto" + path;
        String[] params = new String[]{"list", "true", "file_limit", "25000"};
        return this.doGet(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<T>(){

            @Override
            public T handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 404) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(reader, response.body);
            }
        });
    }

    public Maybe<DbxEntry.WithChildren> getMetadataWithChildrenIfChanged(String path, String previousFolderHash) throws DbxException {
        return this.getMetadataWithChildrenIfChangedBase(path, previousFolderHash, DbxEntry.WithChildren.Reader);
    }

    public <C> Maybe<DbxEntry.WithChildrenC<C>> getMetadataWithChildrenIfChangedC(String path, String previousFolderHash, Collector<DbxEntry, ? extends C> collector) throws DbxException {
        return this.getMetadataWithChildrenIfChangedBase(path, previousFolderHash, new DbxEntry.WithChildrenC.Reader<C>(collector));
    }

    private <T> Maybe<T> getMetadataWithChildrenIfChangedBase(String path, String previousFolderHash, final JsonReader<T> reader) throws DbxException {
        if (previousFolderHash == null) {
            throw new IllegalArgumentException("'previousFolderHash' must not be null");
        }
        if (previousFolderHash.length() == 0) {
            throw new IllegalArgumentException("'previousFolderHash' must not be empty");
        }
        DbxPath.checkArg("path", path);
        String host = this.host.api;
        String apiPath = "1/metadata/auto" + path;
        String[] params = new String[]{"list", "true", "file_limit", "25000", "hash", previousFolderHash};
        return (Maybe)this.doGet(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<Maybe<T>>(){

            @Override
            public Maybe<T> handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 404) {
                    return Maybe.Just(null);
                }
                if (response.statusCode == 304) {
                    return Maybe.Nothing();
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return Maybe.Just(DbxRequestUtil.readJsonFromResponse(reader, response.body));
            }
        });
    }

    public DbxAccountInfo getAccountInfo() throws DbxException {
        String host = this.host.api;
        String apiPath = "1/account/info";
        return this.doGet(host, apiPath, null, null, new DbxRequestUtil.ResponseHandler<DbxAccountInfo>(){

            @Override
            public DbxAccountInfo handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw new DbxException.BadResponse("unexpected response code: " + response.statusCode);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxAccountInfo.Reader, response.body);
            }
        });
    }

    public DbxEntry.File getFile(String path, String rev, OutputStream target) throws DbxException, IOException {
        Downloader downloader = this.startGetFile(path, rev);
        if (downloader == null) {
            return null;
        }
        return downloader.copyBodyAndClose(target);
    }

    public Downloader startGetFile(String path, String revision) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        String apiPath = "1/files/auto" + path;
        String[] params = new String[]{"rev", revision};
        return this.startGetSomething(apiPath, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Downloader startGetSomething(String apiPath, String[] params) throws DbxException {
        DbxEntry metadata;
        String host = this.host.content;
        boolean passedOwnershipOfStream = false;
        HttpRequestor.Response response = DbxRequestUtil.startGet(this.requestConfig, this.accessToken, host, apiPath, params, null);
        if (response.statusCode == 404) {
            Downloader downloader = null;
            return downloader;
        }
        if (response.statusCode != 200) {
            throw DbxRequestUtil.unexpectedStatus(response);
        }
        String metadataString = DbxRequestUtil.getFirstHeader(response, "x-dropbox-metadata");
        try {
            metadata = DbxEntry.Reader.readFully(metadataString);
        }
        catch (JsonReadException ex) {
            throw new DbxException.BadResponse("Bad JSON in X-Dropbox-Metadata header: " + ex.getMessage(), ex);
        }
        if (metadata instanceof DbxEntry.Folder) {
            throw new DbxException.BadResponse("downloaded file, but server returned metadata entry for a folder");
        }
        DbxEntry.File fileMetadata = (DbxEntry.File)metadata;
        Downloader result = new Downloader(fileMetadata, response.body);
        passedOwnershipOfStream = true;
        Downloader downloader = result;
        return downloader;
        finally {
            if (!passedOwnershipOfStream) {
                try {
                    response.body.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public DbxEntry.File uploadFile(String targetPath, DbxWriteMode writeMode, long numBytes, InputStream contents) throws DbxException, IOException {
        return this.uploadFile(targetPath, writeMode, numBytes, new DbxStreamWriter.InputStreamCopier(contents));
    }

    public <E extends Throwable> DbxEntry.File uploadFile(String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFile(targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    public Uploader startUploadFile(String targetPath, DbxWriteMode writeMode, long numBytes) throws DbxException {
        if (numBytes < 0L) {
            if (numBytes != -1L) {
                throw new IllegalArgumentException("numBytes must be -1 or greater; given " + numBytes);
            }
            return this.startUploadFileChunked(targetPath, writeMode, numBytes);
        }
        if (numBytes > 0x800000L) {
            return this.startUploadFileChunked(targetPath, writeMode, numBytes);
        }
        return this.startUploadFileSingle(targetPath, writeMode, numBytes);
    }

    public <E extends Throwable> DbxEntry.File finishUploadFile(Uploader uploader, DbxStreamWriter<E> writer) throws DbxException, E {
        NoThrowOutputStream streamWrapper = new NoThrowOutputStream(uploader.getBody());
        try {
            writer.write(streamWrapper);
            DbxEntry.File file = uploader.finish();
            return file;
        }
        catch (NoThrowOutputStream.HiddenException ex) {
            throw new DbxException.NetworkIO(ex.underlying);
        }
        finally {
            uploader.close();
        }
    }

    public Uploader startUploadFileSingle(String targetPath, DbxWriteMode writeMode, long numBytes) throws DbxException {
        DbxPath.checkArg("targetPath", targetPath);
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be zero or greater");
        }
        String host = this.host.content;
        String apiPath = "1/files_put/auto" + targetPath;
        HttpRequestor.Uploader uploader = DbxRequestUtil.startPut(this.requestConfig, this.accessToken, host, apiPath, writeMode.params, numBytes, null);
        return new SingleUploader(uploader, numBytes);
    }

    public <E extends Throwable> DbxEntry.File uploadFileSingle(String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFileSingle(targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    private <E extends Throwable> HttpRequestor.Response chunkedUploadCommon(String[] params, long chunkSize, DbxStreamWriter<E> writer) throws DbxException, E {
        String apiPath = "1/chunked_upload";
        HttpRequestor.Uploader uploader = DbxRequestUtil.startPut(this.requestConfig, this.accessToken, this.host.content, apiPath, params, chunkSize, null);
        try {
            NoThrowOutputStream nt = new NoThrowOutputStream(uploader.body);
            writer.write(nt);
            long bytesWritten = nt.getBytesWritten();
            if (bytesWritten != chunkSize) {
                throw new IllegalStateException("'chunkSize' is " + chunkSize + ", but 'writer' only wrote " + bytesWritten + " bytes");
            }
            HttpRequestor.Response response = uploader.finish();
            return response;
        }
        catch (IOException ex) {
            throw new DbxException.NetworkIO(ex);
        }
        catch (NoThrowOutputStream.HiddenException ex) {
            throw new DbxException.NetworkIO(ex.underlying);
        }
        finally {
            uploader.close();
        }
    }

    private ChunkedUploadState chunkedUploadCheckForOffsetCorrection(HttpRequestor.Response response) throws DbxException {
        if (response.statusCode != 400) {
            return null;
        }
        byte[] data = DbxRequestUtil.loadErrorBody(response);
        try {
            return ChunkedUploadState.Reader.readFully(data);
        }
        catch (JsonReadException ex) {
            throw new DbxException.BadRequest(DbxRequestUtil.parseErrorBody(400, data));
        }
    }

    private ChunkedUploadState chunkedUploadParse200(HttpRequestor.Response response) throws DbxException.BadResponse, DbxException.NetworkIO {
        assert (response.statusCode == 200) : response.statusCode;
        return DbxRequestUtil.readJsonFromResponse(ChunkedUploadState.Reader, response.body);
    }

    public String chunkedUploadFirst(byte[] data) throws DbxException {
        return this.chunkedUploadFirst(data, 0, data.length);
    }

    public String chunkedUploadFirst(byte[] data, int dataOffset, int dataLength) throws DbxException {
        return this.chunkedUploadFirst(dataLength, new DbxStreamWriter.ByteArrayCopier(data, dataOffset, dataLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> String chunkedUploadFirst(int chunkSize, DbxStreamWriter<E> writer) throws DbxException, E {
        HttpRequestor.Response response = this.chunkedUploadCommon(new String[0], chunkSize, writer);
        try {
            ChunkedUploadState correctedState = this.chunkedUploadCheckForOffsetCorrection(response);
            if (correctedState != null) {
                throw new DbxException.BadResponse("Got offset correction response on first chunk.");
            }
            if (response.statusCode == 404) {
                throw new DbxException.BadResponse("Got a 404, but we didn't send an upload_id");
            }
            if (response.statusCode != 200) {
                throw DbxRequestUtil.unexpectedStatus(response);
            }
            ChunkedUploadState returnedState = this.chunkedUploadParse200(response);
            if (returnedState.offset != (long)chunkSize) {
                throw new DbxException.BadResponse("Sent " + chunkSize + " bytes, but returned offset is " + returnedState.offset);
            }
            String string = returnedState.uploadId;
            return string;
        }
        finally {
            IOUtil.closeInput(response.body);
        }
    }

    public long chunkedUploadAppend(String uploadId, long uploadOffset, byte[] data) throws DbxException {
        return this.chunkedUploadAppend(uploadId, uploadOffset, data, 0, data.length);
    }

    public long chunkedUploadAppend(String uploadId, long uploadOffset, byte[] data, int dataOffset, int dataLength) throws DbxException {
        return this.chunkedUploadAppend(uploadId, uploadOffset, dataLength, new DbxStreamWriter.ByteArrayCopier(data, dataOffset, dataLength));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Throwable> long chunkedUploadAppend(String uploadId, long uploadOffset, long chunkSize, DbxStreamWriter<E> writer) throws DbxException, E {
        if (uploadId == null) {
            throw new IllegalArgumentException("'uploadId' can't be null");
        }
        if (uploadId.length() == 0) {
            throw new IllegalArgumentException("'uploadId' can't be empty");
        }
        if (uploadOffset < 0L) {
            throw new IllegalArgumentException("'offset' can't be negative");
        }
        String[] params = new String[]{"upload_id", uploadId, "offset", Long.toString(uploadOffset)};
        HttpRequestor.Response response = this.chunkedUploadCommon(params, chunkSize, writer);
        try {
            ChunkedUploadState correctedState = this.chunkedUploadCheckForOffsetCorrection(response);
            if (correctedState != null) {
                if (!correctedState.uploadId.equals(uploadId)) {
                    throw new DbxException.BadResponse("uploadId mismatch: us=" + StringUtil.jq(uploadId) + ", server=" + StringUtil.jq(correctedState.uploadId));
                }
                if (correctedState.offset == uploadOffset) {
                    throw new DbxException.BadResponse("Corrected offset is same as given: " + uploadOffset);
                }
                long l = correctedState.offset;
                return l;
            }
            if (response.statusCode != 200) {
                throw DbxRequestUtil.unexpectedStatus(response);
            }
            ChunkedUploadState returnedState = this.chunkedUploadParse200(response);
            long expectedOffset = uploadOffset + chunkSize;
            if (returnedState.offset != expectedOffset) {
                throw new DbxException.BadResponse("Expected offset " + expectedOffset + " bytes, but returned offset is " + returnedState.offset);
            }
            long l = -1L;
            return l;
        }
        finally {
            IOUtil.closeInput(response.body);
        }
    }

    public DbxEntry.File chunkedUploadFinish(String targetPath, DbxWriteMode writeMode, String uploadId) throws DbxException {
        DbxPath.checkArgNonRoot("targetPath", targetPath);
        String apiPath = "1/commit_chunked_upload/auto" + targetPath;
        String[] params = new String[]{"upload_id", uploadId};
        params = LangUtil.arrayConcat(params, writeMode.params);
        return this.doPost(this.host.content, apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxEntry.File>(){

            @Override
            public DbxEntry.File handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                DbxEntry entry = DbxRequestUtil.readJsonFromResponse(DbxEntry.Reader, response.body);
                if (entry instanceof DbxEntry.Folder) {
                    throw new DbxException.BadResponse("uploaded file, but server returned metadata entry for a folder");
                }
                return (DbxEntry.File)entry;
            }
        });
    }

    public Uploader startUploadFileChunked(String targetPath, DbxWriteMode writeMode, long numBytes) {
        return this.startUploadFileChunked(0x400000, targetPath, writeMode, numBytes);
    }

    public Uploader startUploadFileChunked(int chunkSize, String targetPath, DbxWriteMode writeMode, long numBytes) {
        DbxPath.checkArg("targetPath", targetPath);
        if (writeMode == null) {
            throw new IllegalArgumentException("'writeMode' can't be null");
        }
        return new ChunkedUploader(targetPath, writeMode, numBytes, new ChunkedUploadOutputStream(chunkSize));
    }

    public <E extends Throwable> DbxEntry.File uploadFileChunked(String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFileChunked(targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    public <E extends Throwable> DbxEntry.File uploadFileChunked(int chunkSize, String targetPath, DbxWriteMode writeMode, long numBytes, DbxStreamWriter<E> writer) throws DbxException, E {
        Uploader uploader = this.startUploadFileChunked(chunkSize, targetPath, writeMode, numBytes);
        return this.finishUploadFile(uploader, writer);
    }

    public DbxDelta<DbxEntry> getDelta(String cursor) throws DbxException {
        String host = this.host.api;
        String apiPath = "1/delta";
        String[] params = new String[]{"cursor", cursor};
        return this.doPost(host, apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxDelta<DbxEntry>>(){

            @Override
            public DbxDelta<DbxEntry> handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (DbxDelta)((Object)DbxRequestUtil.readJsonFromResponse(new DbxDelta.Reader<DbxEntry>(DbxEntry.Reader), response.body));
            }
        });
    }

    public <C> DbxDeltaC<C> getDeltaC(String cursor, final Collector<DbxDeltaC.Entry<DbxEntry>, C> collector) throws DbxException {
        String host = this.host.api;
        String apiPath = "1/delta";
        return (DbxDeltaC)this.doPost(host, apiPath, new String[]{"cursor", cursor}, null, new DbxRequestUtil.ResponseHandler<DbxDeltaC<C>>(){

            @Override
            public DbxDeltaC<C> handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (DbxDeltaC)DbxRequestUtil.readJsonFromResponse(new DbxDeltaC.Reader(DbxEntry.Reader, collector), response.body);
            }
        });
    }

    public DbxEntry.File getThumbnail(DbxThumbnailSize sizeBound, DbxThumbnailFormat format, String path, String revision, OutputStream target) throws DbxException, IOException {
        if (target == null) {
            throw new IllegalArgumentException("'target' can't be null");
        }
        Downloader downloader = this.startGetThumbnail(sizeBound, format, path, revision);
        if (downloader == null) {
            return null;
        }
        return downloader.copyBodyAndClose(target);
    }

    public Downloader startGetThumbnail(DbxThumbnailSize sizeBound, DbxThumbnailFormat format, String path, String revision) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        if (sizeBound == null) {
            throw new IllegalArgumentException("'size' can't be null");
        }
        if (format == null) {
            throw new IllegalArgumentException("'format' can't be null");
        }
        String apiPath = "1/thumbnails/auto" + path;
        String[] params = new String[]{"size", sizeBound.ident, "format", format.ident, "rev", revision};
        return this.startGetSomething(apiPath, params);
    }

    public List<DbxEntry.File> getRevisions(String path) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        String apiPath = "1/revisions/auto" + path;
        return this.doGet(this.host.api, apiPath, null, null, new DbxRequestUtil.ResponseHandler<List<DbxEntry.File>>(){

            @Override
            public List<DbxEntry.File> handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 406) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (List)DbxRequestUtil.readJsonFromResponse(JsonArrayReader.mk(DbxEntry.File.Reader), response.body);
            }
        });
    }

    public DbxEntry.File restoreFile(String path, String rev) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        if (rev == null) {
            throw new IllegalArgumentException("'rev' can't be null");
        }
        if (rev.length() == 0) {
            throw new IllegalArgumentException("'rev' can't be empty");
        }
        String apiPath = "1/restore/auto" + path;
        String[] params = new String[]{"rev", rev};
        return this.doGet(this.host.api, apiPath, params, null, new DbxRequestUtil.ResponseHandler<DbxEntry.File>(){

            @Override
            public DbxEntry.File handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 404) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.File.Reader, response.body);
            }
        });
    }

    public List<DbxEntry> searchFileAndFolderNames(String basePath, String query) throws DbxException {
        DbxPath.checkArg("basePath", basePath);
        if (query == null) {
            throw new IllegalArgumentException("'query' can't be null");
        }
        if (query.length() == 0) {
            throw new IllegalArgumentException("'query' can't be empty");
        }
        String apiPath = "1/search/auto" + basePath;
        String[] params = new String[]{"query", query};
        return this.doPost(this.host.api, apiPath, params, null, new DbxRequestUtil.ResponseHandler<List<DbxEntry>>(){

            @Override
            public List<DbxEntry> handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return (List)DbxRequestUtil.readJsonFromResponse(JsonArrayReader.mk(DbxEntry.Reader), response.body);
            }
        });
    }

    public String createShareableUrl(String path) throws DbxException {
        DbxPath.checkArg("path", path);
        String apiPath = "1/shares/auto" + path;
        String[] params = new String[]{"short_url", "false"};
        return this.doPost(this.host.api, apiPath, params, null, new DbxRequestUtil.ResponseHandler<String>(){

            @Override
            public String handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 404) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                DbxUrlWithExpiration uwe = DbxRequestUtil.readJsonFromResponse(DbxUrlWithExpiration.Reader, response.body);
                return uwe.url;
            }
        });
    }

    public DbxUrlWithExpiration createTemporaryDirectUrl(String path) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        String apiPath = "1/media/auto" + path;
        return this.doPost(this.host.api, apiPath, null, null, new DbxRequestUtil.ResponseHandler<DbxUrlWithExpiration>(){

            @Override
            public DbxUrlWithExpiration handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 404) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxUrlWithExpiration.Reader, response.body);
            }
        });
    }

    public String createCopyRef(String path) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        String apiPath = "1/copy_ref/auto" + path;
        return this.doPost(this.host.api, apiPath, null, null, new DbxRequestUtil.ResponseHandler<String>(){

            @Override
            public String handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 404) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                CopyRef copyRef = DbxRequestUtil.readJsonFromResponse(CopyRef.Reader, response.body);
                return copyRef.id;
            }
        });
    }

    public DbxEntry copy(String fromPath, String toPath) throws DbxException {
        DbxPath.checkArg("fromPath", fromPath);
        DbxPath.checkArgNonRoot("toPath", toPath);
        String[] params = new String[]{"root", "auto", "from_path", fromPath, "to_path", toPath};
        return this.doPost(this.host.api, "1/fileops/copy", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.Reader, response.body);
            }
        });
    }

    public DbxEntry copyFromCopyRef(String copyRef, String toPath) throws DbxException {
        if (copyRef == null) {
            throw new IllegalArgumentException("'copyRef' can't be null");
        }
        if (copyRef.length() == 0) {
            throw new IllegalArgumentException("'copyRef' can't be empty");
        }
        DbxPath.checkArgNonRoot("toPath", toPath);
        String[] params = new String[]{"root", "auto", "from_copy_ref", copyRef, "to_path", toPath};
        return this.doPost(this.host.api, "1/fileops/copy", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.Reader, response.body);
            }
        });
    }

    public DbxEntry.Folder createFolder(String path) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        String[] params = new String[]{"root", "auto", "path", path};
        return this.doPost(this.host.api, "1/fileops/create_folder", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry.Folder>(){

            @Override
            public DbxEntry.Folder handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode == 403) {
                    return null;
                }
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.Folder.Reader, response.body);
            }
        });
    }

    public void delete(String path) throws DbxException {
        DbxPath.checkArgNonRoot("path", path);
        String[] params = new String[]{"root", "auto", "path", path};
        this.doPost(this.host.api, "1/fileops/delete", params, null, new DbxRequestUtil.ResponseHandler<Void>(){

            @Override
            public Void handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return null;
            }
        });
    }

    public DbxEntry move(String fromPath, String toPath) throws DbxException {
        DbxPath.checkArgNonRoot("fromPath", fromPath);
        DbxPath.checkArgNonRoot("toPath", toPath);
        String[] params = new String[]{"root", "auto", "from_path", fromPath, "to_path", toPath};
        return this.doPost(this.host.api, "1/fileops/move", params, null, new DbxRequestUtil.ResponseHandler<DbxEntry>(){

            @Override
            public DbxEntry handle(HttpRequestor.Response response) throws DbxException {
                if (response.statusCode != 200) {
                    throw DbxRequestUtil.unexpectedStatus(response);
                }
                return DbxRequestUtil.readJsonFromResponse(DbxEntry.Reader, response.body);
            }
        });
    }

    private <T> T doGet(String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers, DbxRequestUtil.ResponseHandler<T> handler) throws DbxException {
        return DbxRequestUtil.doGet(this.requestConfig, this.accessToken, host, path, params, headers, handler);
    }

    public <T> T doPost(String host, String path, String[] params, ArrayList<HttpRequestor.Header> headers, DbxRequestUtil.ResponseHandler<T> handler) throws DbxException {
        return DbxRequestUtil.doPost(this.requestConfig, this.accessToken, host, path, params, headers, handler);
    }

    public static abstract class Uploader {
        public abstract OutputStream getBody();

        public abstract void abort();

        public abstract void close();

        public abstract DbxEntry.File finish() throws DbxException;
    }

    private static final class CopyRef {
        public final String id;
        public final Date expires;
        public static final JsonReader<CopyRef> Reader = new JsonReader<CopyRef>(){

            @Override
            public CopyRef read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = JsonReader.expectObjectStart(parser);
                String id = null;
                Date expires = null;
                while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    parser.nextToken();
                    try {
                        if (fieldName.equals("copy_ref")) {
                            id = JsonReader.StringReader.readField(parser, fieldName, id);
                            continue;
                        }
                        if (fieldName.equals("expires")) {
                            expires = JsonDateReader.Dropbox.readField(parser, fieldName, expires);
                            continue;
                        }
                        JsonReader.skipValue(parser);
                    }
                    catch (JsonReadException ex) {
                        throw ex.addFieldContext(fieldName);
                    }
                }
                JsonReader.expectObjectEnd(parser);
                if (id == null) {
                    throw new JsonReadException("missing field \"copy_ref\"", top);
                }
                if (expires == null) {
                    throw new JsonReadException("missing field \"expires\"", top);
                }
                return new CopyRef(id, expires);
            }
        };

        private CopyRef(String id, Date expires) {
            this.id = id;
            this.expires = expires;
        }
    }

    public static final class IODbxException
    extends IOException {
        public final DbxException underlying;

        public IODbxException(DbxException underlying) {
            super(underlying);
            this.underlying = underlying;
        }
    }

    private final class ChunkedUploadOutputStream
    extends OutputStream {
        private final byte[] chunk;
        private int chunkPos = 0;
        private String uploadId;
        private long uploadOffset;

        private ChunkedUploadOutputStream(int chunkSize) {
            this.chunk = new byte[chunkSize];
            this.chunkPos = 0;
        }

        @Override
        public void write(int i) throws IOException {
            this.chunk[this.chunkPos++] = (byte)i;
            try {
                this.finishChunkIfNecessary();
            }
            catch (DbxException ex) {
                throw new IODbxException(ex);
            }
        }

        private void finishChunkIfNecessary() throws DbxException {
            assert (this.chunkPos <= this.chunk.length);
            if (this.chunkPos == this.chunk.length) {
                this.finishChunk();
            }
        }

        private void finishChunk() throws DbxException {
            if (this.chunkPos == 0) {
                return;
            }
            if (this.uploadId == null) {
                this.uploadId = DbxRequestUtil.runAndRetry(3, new DbxRequestUtil.RequestMaker<String, RuntimeException>(){

                    @Override
                    public String run() throws DbxException {
                        return DbxClient.this.chunkedUploadFirst(ChunkedUploadOutputStream.this.chunk, 0, ChunkedUploadOutputStream.this.chunkPos);
                    }
                });
                this.uploadOffset = this.chunkPos;
            } else {
                int arrayOffset = 0;
                while (true) {
                    final int arrayOffsetFinal = arrayOffset;
                    long correctedOffset = DbxRequestUtil.runAndRetry(3, new DbxRequestUtil.RequestMaker<Long, RuntimeException>(){

                        @Override
                        public Long run() throws DbxException {
                            return DbxClient.this.chunkedUploadAppend(ChunkedUploadOutputStream.this.uploadId, ChunkedUploadOutputStream.this.uploadOffset, ChunkedUploadOutputStream.this.chunk, arrayOffsetFinal, ChunkedUploadOutputStream.this.chunkPos - arrayOffsetFinal);
                        }
                    });
                    long expectedOffset = this.uploadOffset + (long)this.chunkPos;
                    if (correctedOffset == -1L) {
                        this.uploadOffset = expectedOffset;
                        break;
                    }
                    assert (correctedOffset != expectedOffset);
                    if (correctedOffset < this.uploadOffset) {
                        throw new DbxException.BadResponse("we were at offset " + this.uploadOffset + ", server said " + correctedOffset);
                    }
                    if (correctedOffset > expectedOffset) {
                        throw new DbxException.BadResponse("we were at offset " + this.uploadOffset + ", server said " + correctedOffset);
                    }
                    int adjustAmount = (int)(correctedOffset - this.uploadOffset);
                    arrayOffset += adjustAmount;
                }
            }
            this.chunkPos = 0;
        }

        @Override
        public void write(byte[] bytes, int offset, int length) throws IOException {
            int bytesToCopy;
            int inputEnd = offset + length;
            for (int inputPos = offset; inputPos < inputEnd; inputPos += bytesToCopy) {
                int spaceInChunk = this.chunk.length - this.chunkPos;
                int leftToWrite = inputEnd - inputPos;
                bytesToCopy = Math.min(leftToWrite, spaceInChunk);
                System.arraycopy(bytes, inputPos, this.chunk, this.chunkPos, bytesToCopy);
                this.chunkPos += bytesToCopy;
                try {
                    this.finishChunkIfNecessary();
                    continue;
                }
                catch (DbxException ex) {
                    throw new IODbxException(ex);
                }
            }
        }

        @Override
        public void close() throws IOException {
        }
    }

    private final class ChunkedUploader
    extends Uploader {
        private final String targetPath;
        private final DbxWriteMode writeMode;
        private final long numBytes;
        private final ChunkedUploadOutputStream body;

        private ChunkedUploader(String targetPath, DbxWriteMode writeMode, long numBytes, ChunkedUploadOutputStream body) {
            this.targetPath = targetPath;
            this.writeMode = writeMode;
            this.numBytes = numBytes;
            this.body = body;
        }

        @Override
        public OutputStream getBody() {
            return this.body;
        }

        @Override
        public void abort() {
        }

        @Override
        public DbxEntry.File finish() throws DbxException {
            if (this.body.uploadId == null) {
                return DbxClient.this.uploadFileSingle(this.targetPath, this.writeMode, this.body.chunkPos, new DbxStreamWriter.ByteArrayCopier(this.body.chunk, 0, this.body.chunkPos));
            }
            this.body.finishChunk();
            if (this.numBytes != -1L && this.numBytes != this.body.uploadOffset) {
                throw new IllegalStateException("'numBytes' is " + this.numBytes + " but you wrote " + this.body.uploadOffset + " bytes");
            }
            return DbxRequestUtil.runAndRetry(3, new DbxRequestUtil.RequestMaker<DbxEntry.File, RuntimeException>(){

                @Override
                public DbxEntry.File run() throws DbxException {
                    return DbxClient.this.chunkedUploadFinish(ChunkedUploader.this.targetPath, ChunkedUploader.this.writeMode, ChunkedUploader.this.body.uploadId);
                }
            });
        }

        @Override
        public void close() {
        }
    }

    private static final class ChunkedUploadState
    extends Dumpable {
        public final String uploadId;
        public final long offset;
        public static final JsonReader<ChunkedUploadState> Reader = new JsonReader<ChunkedUploadState>(){

            @Override
            public ChunkedUploadState read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = JsonReader.expectObjectStart(parser);
                String uploadId = null;
                long bytesComplete = -1L;
                while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    parser.nextToken();
                    try {
                        if (fieldName.equals("upload_id")) {
                            uploadId = JsonReader.StringReader.readField(parser, fieldName, uploadId);
                            continue;
                        }
                        if (fieldName.equals("offset")) {
                            bytesComplete = JsonReader.readUnsignedLongField(parser, fieldName, bytesComplete);
                            continue;
                        }
                        JsonReader.skipValue(parser);
                    }
                    catch (JsonReadException ex) {
                        throw ex.addFieldContext(fieldName);
                    }
                }
                JsonReader.expectObjectEnd(parser);
                if (uploadId == null) {
                    throw new JsonReadException("missing field \"upload_id\"", top);
                }
                if (bytesComplete == -1L) {
                    throw new JsonReadException("missing field \"offset\"", top);
                }
                return new ChunkedUploadState(uploadId, bytesComplete);
            }
        };

        public ChunkedUploadState(String uploadId, long offset) {
            if (uploadId == null) {
                throw new IllegalArgumentException("'uploadId' can't be null");
            }
            if (uploadId.length() == 0) {
                throw new IllegalArgumentException("'uploadId' can't be empty");
            }
            if (offset < 0L) {
                throw new IllegalArgumentException("'offset' can't be negative");
            }
            this.uploadId = uploadId;
            this.offset = offset;
        }

        @Override
        protected void dumpFields(DumpWriter w) {
            w.field("uploadId", this.uploadId);
            w.field("offset", this.offset);
        }
    }

    private static final class SingleUploader
    extends Uploader {
        private HttpRequestor.Uploader httpUploader;
        private final long claimedBytes;
        private final CountingOutputStream body;

        public SingleUploader(HttpRequestor.Uploader httpUploader, long claimedBytes) {
            if (claimedBytes < 0L) {
                throw new IllegalArgumentException("'numBytes' must be greater than or equal to 0");
            }
            this.httpUploader = httpUploader;
            this.claimedBytes = claimedBytes;
            this.body = new CountingOutputStream(httpUploader.body);
        }

        @Override
        public OutputStream getBody() {
            return this.body;
        }

        @Override
        public void abort() {
            if (this.httpUploader == null) {
                throw new IllegalStateException("already called 'finish', 'abort', or 'close'");
            }
            HttpRequestor.Uploader p = this.httpUploader;
            this.httpUploader = null;
            p.abort();
        }

        @Override
        public void close() {
            if (this.httpUploader == null) {
                return;
            }
            this.abort();
        }

        @Override
        public DbxEntry.File finish() throws DbxException {
            HttpRequestor.Response response;
            long bytesWritten;
            if (this.httpUploader == null) {
                throw new IllegalStateException("already called 'finish', 'abort', or 'close'");
            }
            HttpRequestor.Uploader u = this.httpUploader;
            this.httpUploader = null;
            try {
                bytesWritten = this.body.getBytesWritten();
                if (this.claimedBytes != bytesWritten) {
                    u.abort();
                    throw new IllegalStateException("You said you were going to upload " + this.claimedBytes + " bytes, but you wrote " + bytesWritten + " bytes to the Uploader's 'body' stream.");
                }
                response = u.finish();
            }
            catch (IOException ex) {
                throw new DbxException.NetworkIO(ex);
            }
            finally {
                u.close();
            }
            return DbxRequestUtil.finishResponse(response, new DbxRequestUtil.ResponseHandler<DbxEntry.File>(){

                @Override
                public DbxEntry.File handle(HttpRequestor.Response response) throws DbxException {
                    if (response.statusCode != 200) {
                        throw DbxRequestUtil.unexpectedStatus(response);
                    }
                    DbxEntry entry = DbxRequestUtil.readJsonFromResponse(DbxEntry.Reader, response.body);
                    if (entry instanceof DbxEntry.Folder) {
                        throw new DbxException.BadResponse("uploaded file, but server returned metadata entry for a folder");
                    }
                    DbxEntry.File f = (DbxEntry.File)entry;
                    if (f.numBytes != bytesWritten) {
                        throw new DbxException.BadResponse("we uploaded " + bytesWritten + ", but server returned metadata entry with file size " + f.numBytes);
                    }
                    return f;
                }
            });
        }
    }

    public static final class Downloader {
        public final DbxEntry.File metadata;
        public final InputStream body;

        public Downloader(DbxEntry.File metadata, InputStream body) {
            this.metadata = metadata;
            this.body = body;
        }

        DbxEntry.File copyBodyAndClose(OutputStream target) throws DbxException, IOException {
            try {
                IOUtil.copyStreamToStream(this.body, target);
            }
            catch (IOUtil.ReadException ex) {
                throw new DbxException.NetworkIO(ex.underlying);
            }
            catch (IOUtil.WriteException ex) {
                throw ex.underlying;
            }
            finally {
                this.close();
            }
            return this.metadata;
        }

        public void close() {
            IOUtil.closeInput(this.body);
        }
    }
}

