/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.DumpWriter;
import com.dropbox.core.util.Dumpable;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public class DbxAccountInfo
extends Dumpable {
    public final long userId;
    public final String displayName;
    public final String country;
    public final String referralLink;
    public final Quota quota;
    public static final JsonReader<DbxAccountInfo> Reader = new JsonReader<DbxAccountInfo>(){

        @Override
        public final DbxAccountInfo read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            long uid = -1L;
            String display_name = null;
            String country = null;
            String referral_link = null;
            Quota quota_info = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                try {
                    int fi = FM.get(fieldName);
                    switch (fi) {
                        case -1: {
                            JsonReader.skipValue(parser);
                            break;
                        }
                        case 0: {
                            uid = JsonReader.readUnsignedLongField(parser, fieldName, uid);
                            break;
                        }
                        case 1: {
                            display_name = JsonReader.StringReader.readField(parser, fieldName, display_name);
                            break;
                        }
                        case 2: {
                            country = JsonReader.StringReader.readField(parser, fieldName, country);
                            break;
                        }
                        case 3: {
                            referral_link = JsonReader.StringReader.readField(parser, fieldName, referral_link);
                            break;
                        }
                        case 4: {
                            quota_info = Quota.Reader.readField(parser, fieldName, quota_info);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("bad index: " + fi + ", field = \"" + fieldName + "\""));
                        }
                    }
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (uid < 0L) {
                throw new JsonReadException("missing field \"uid\"", top);
            }
            if (display_name == null) {
                throw new JsonReadException("missing field \"display_name\"", top);
            }
            if (country == null) {
                throw new JsonReadException("missing field \"country\"", top);
            }
            if (referral_link == null) {
                throw new JsonReadException("missing field \"referral_link\"", top);
            }
            if (quota_info == null) {
                throw new JsonReadException("missing field \"quota_info\"", top);
            }
            return new DbxAccountInfo(uid, display_name, country, referral_link, quota_info);
        }
    };
    private static final int FM_uid = 0;
    private static final int FM_display_name = 1;
    private static final int FM_country = 2;
    private static final int FM_referral_link = 3;
    private static final int FM_quota_info = 4;
    private static final JsonReader.FieldMapping FM;

    public DbxAccountInfo(long userId, String displayName, String country, String referralLink, Quota quota) {
        this.userId = userId;
        this.displayName = displayName;
        this.country = country;
        this.referralLink = referralLink;
        this.quota = quota;
    }

    @Override
    protected void dumpFields(DumpWriter out) {
        out.field("userId", this.userId);
        out.field("displayName", this.displayName);
        out.field("country", this.country);
        out.field("referralLink", this.referralLink);
        out.field("quota", this.quota);
    }

    static {
        JsonReader.FieldMapping.Builder b = new JsonReader.FieldMapping.Builder();
        b.add("uid", 0);
        b.add("display_name", 1);
        b.add("country", 2);
        b.add("referral_link", 3);
        b.add("quota_info", 4);
        FM = b.build();
    }

    public static final class Quota
    extends Dumpable {
        public final long total;
        public final long normal;
        public final long shared;
        public static final JsonReader<Quota> Reader = new JsonReader<Quota>(){

            @Override
            public final Quota read(JsonParser parser) throws IOException, JsonReadException {
                JsonLocation top = JsonReader.expectObjectStart(parser);
                long quota = -1L;
                long normal = -1L;
                long shared = -1L;
                while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String fieldName = parser.getCurrentName();
                    parser.nextToken();
                    int fi = FM.get(fieldName);
                    try {
                        if (fi == -1) {
                            JsonReader.skipValue(parser);
                        }
                        switch (fi) {
                            case 0: {
                                quota = JsonReader.readUnsignedLongField(parser, fieldName, quota);
                                break;
                            }
                            case 1: {
                                normal = JsonReader.readUnsignedLongField(parser, fieldName, normal);
                                break;
                            }
                            case 2: {
                                shared = JsonReader.readUnsignedLongField(parser, fieldName, shared);
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("bad index: " + fi + ", field = \"" + fieldName + "\""));
                            }
                        }
                    }
                    catch (JsonReadException ex) {
                        throw ex.addFieldContext(fieldName);
                    }
                }
                JsonReader.expectObjectEnd(parser);
                if (quota < 0L) {
                    throw new JsonReadException("missing field \"quota\"", top);
                }
                if (normal < 0L) {
                    throw new JsonReadException("missing field \"normal\"", top);
                }
                if (shared < 0L) {
                    throw new JsonReadException("missing field \"shared\"", top);
                }
                return new Quota(quota, normal, shared);
            }
        };
        private static final int FM_quota = 0;
        private static final int FM_normal = 1;
        private static final int FM_shared = 2;
        private static final JsonReader.FieldMapping FM;

        public Quota(long quota, long normal, long quotaShared) {
            this.total = quota;
            this.normal = normal;
            this.shared = quotaShared;
        }

        @Override
        protected void dumpFields(DumpWriter out) {
            out.field("total", this.total);
            out.field("normal", this.normal);
            out.field("shared", this.shared);
        }

        static {
            JsonReader.FieldMapping.Builder b = new JsonReader.FieldMapping.Builder();
            b.add("quota", 0);
            b.add("normal", 1);
            b.add("shared", 2);
            FM = b.build();
        }
    }
}

