/*
    Copyright (c) 2005-2026 Leisenfels GmbH. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.s3;

import org.apache.commons.vfs2.provider.FileNameParser;
import org.apache.commons.vfs2.provider.URLFileNameParser;


/**
 * Implementation for Amazon S3.
 *
 * @author Axel Schwolow
 * @created 2016-01-01
 * @since 1.6
 */
public class S3FileNameParser extends URLFileNameParser {


    /**
     * The shared parser instance.
     */
    protected static S3FileNameParser sharedInstance = null;


    /**
     * Constructor method.
     */
    public S3FileNameParser() {
        super(80);  // Port 80 (HTTP port)
    }

    /**
     * Provides the shared instance of the parser.
     *
     * @return Shared instance
     */
    public static synchronized FileNameParser getSharedInstance() {

        if (sharedInstance == null) sharedInstance = new S3FileNameParser();
        return sharedInstance;
    }
}
