/*
    Copyright (c) 2005-2026 Leisenfels GmbH. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.io;

import org.apache.commons.vfs2.FileObject;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;


/**
 * This class holds various methods for common use.
 *
 * @author Axel Schwolow
 * @created 2016-01-01
 * @since 1.6
 */
public class IOUtils {


    /**
     * Constructor method for i18n purposes only.
     *
     * @throws InstantiationException Error indication
     */
    public IOUtils() throws InstantiationException {

        if (!java.beans.Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    /**
     * Reads all binary data from the given network file.
     *
     * @param vfsfile The network file
     * @return Binary data from stream
     * @throws NullPointerException If a parameter is <code>null</code>
     * @throws IOException          If an I/O error occurs
     */
    public static byte[] readData(FileObject vfsfile) throws IOException {

        InputStream istream = vfsfile.getContent().getInputStream();
        byte[] data = readData(istream);
        istream.close();
        return data;
    }

    /**
     * Reads all binary data from the given stream.
     * <p>
     * The input stream is never closed here.
     *
     * @param istream The input stream
     * @return Binary data from stream
     * @throws NullPointerException If a parameter is <code>null</code>
     * @throws IOException          If an I/O error occurs
     */
    public static byte[] readData(InputStream istream) throws IOException {

        byte[] buffer = new byte[1024];
        int len;

        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        while ((len = istream.read(buffer)) != -1) {
            ostream.write(buffer, 0, len);
        }
        ostream.flush();

        return ostream.toByteArray();
    }
}
