/*
    Copyright (c) 2005-2026 Leisenfels GmbH. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.dropbox;

import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.v2.DbxClientV2;
import org.apache.commons.vfs2.FileSystemOptions;


/**
 * Factory for Dropbox clients.
 *
 * @author Axel Schwolow
 * @created 2016-01-01
 * @since 1.6
 */
public class DbxClientFactory {


    /**
     * Constructor method (do not use).
     *
     * @throws InstantiationException Error indication
     */
    public DbxClientFactory() throws InstantiationException {

        if (!java.beans.Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }

    /**
     * Creates a new connection to the server.
     *
     * @param options   The file system options
     * @param reqconfig The request configuration
     * @return The new client
     * @since 2.8
     */
    public static DbxClientV2 createClient(FileSystemOptions options, DbxRequestConfig reqconfig) {

        // All required data is provided by the file system options (host, port etc. do not matter here)
        DbxFileSystemConfigBuilder builder = DbxFileSystemConfigBuilder.getSharedInstance();
        String accesstoken = builder.getAccessToken(options);
        return new DbxClientV2(reqconfig, accesstoken);
    }
}
