/*
    Copyright (c) 2005-2026 Leisenfels. All rights reserved.
    Use is subject to license terms.
*/

package com.lf.vfslib.core;

/**
 * Provides constants for the VFSLib classes.
 *
 * @author Axel Schwolow
 * @created 2014-02-03
 * @since 1.6
 */
public class VFSLibConstants {


    /**
     * Represents the "Content-Length" attribute required for proper uploading (cloud file systems).
     */
    public final static String ATTR_CONTENT_LENGTH = "Content-Length";


    /**
     * Constructor method for i18n purposes only.
     *
     * @throws InstantiationException Error indication
     */
    public VFSLibConstants() throws InstantiationException {

        if (!java.beans.Beans.isDesignTime()) {
            throw new InstantiationException("Do not use this constructor!");
        }
    }
}
